
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  spi.h: SD/MMC card SPI communication functions
  Written by Mauro Grassi and updated by Nicholas Vinen, 2009-2013
*/

#ifndef SPI_H
#define SPI_H

#include <xc.h>
#include "GenericTypeDefs.h"

#define SDCS			(LATBbits.LATB15)
#define SDCS_TRIS		(TRISBbits.TRISB15)

void 					DeinitSPI();
void 					InitSPI(int speed);
unsigned int 			WriteSPI(unsigned int x);
unsigned int 			WriteSPIWithoutSS(unsigned int x);
void					BulkReadSPI(BYTE* data);
void                    BulkReadSPIInto(unsigned char* buf);

#endif
